//
//  FSFileItem.h
//  PDFReader
//
//  Created by Dong Li on 12-4-26.
//  Copyright (c) 2013年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum __FILE_CATEGORY : char {
    FC_INVALID = -1, 
    FC_UNKNOWN = 0,
    FC_PLAIN_TEXT,
    FC_SOURCE_CODE,
    FC_RICH_TEXT,
    FC_OFFICE,
    FC_XML,
    FC_PDF,
    FC_PHOTO,
    FC_AUDIO,
    FC_VIDEO,
    FC_COMPRESSED,
    FC_DATABASE,
    FC_BIN,
    FC_OTHERS,
    FC_DIRECTORY = 0x7F
} FILE_CATEGORY;

@interface FSFileItem : NSObject {
    unsigned long _fileNumber;
    UInt16 _permissions;
    UInt64 _fileSize;
    NSString *_path;
    NSString *_fileName;
    NSString *_displayName;
    NSString *_statistic;
    NSString *_extension;
    NSString *_creationTime;
    NSString *_iconName;
    NSDictionary *_extendedAttributes;
    NSMutableArray *_subitems;
    
    struct {
        unsigned int _fileCategory:8;
        unsigned int _directory:1;
        unsigned int _selected:1;
        unsigned int _cut:1;
        unsigned int _reserved:21;
    } flags;
}

@property (nonatomic, retain, readonly) NSString *path;
@property (nonatomic, retain, readonly) NSString *fileName;
@property (nonatomic, retain, readonly) NSString *displayName;
@property (nonatomic, retain, readonly) NSString *statistic;
@property (nonatomic, retain, readonly) NSString *extension;
@property (nonatomic, retain, readonly) NSString *creationTime;
@property (nonatomic, retain, readonly) NSString *iconName;
@property (nonatomic, retain, readonly) NSArray *subitems;
@property (nonatomic, assign, readonly) UInt64 fileSize;
@property (nonatomic, assign, readonly) FILE_CATEGORY fileCategory;
@property (nonatomic, assign, readonly) BOOL isDirectory;
@property (nonatomic, assign, getter = isSelected) BOOL selected;
@property (nonatomic, assign, getter = isCut) BOOL cut;

- (id)initWithParentPath:(NSString *)parentPath fileName:(NSString *)fileName;
- (id)initWithPath:(NSString *)path;
- (void)loadAttributesIfNeeded;
- (void)clearSubitems;
- (void)invertSelection;
- (BOOL)isInboxDirectory;

@end
